//#version unofficial MegaPov 1.0;

#include "colors.inc"
#include "textures.inc"

#include "brain2.inc"
#include "oeil.inc"
#include "Lit.inc"

#include "makesnow.inc"
#include "library_old.inc"

// place all settings of globally influenced features here
global_settings {
	assumed_gamma 1.0
	max_trace_level 30
}

//MonObject

#declare Epaisseur = 0.05;
#declare Largeur = 0.3;

#declare MonObjet = union {
box { 0 <2, Epaisseur, Largeur>
  texture {Tinny_Brass}
  translate <0, -Largeur/2, -Epaisseur/2>
  
  translate 1*y
}

box { 0 <4, Epaisseur, Largeur>
  texture {Gold_Metal}  
  translate <0, -Largeur/2, -Epaisseur/2>
  
  rotate z*36.8
}

} //fin de MonObjet

//Tour

#declare Tour = union {

cylinder {0*x, 15*y,  1.25 texture {Chrome_Metal}}

#declare Count = 0;
#while (Count < 72*3)
  object {MonObjet 
        translate 1.25*x -1*y
        
        rotate Count*(25/3)*y
        translate y*(15/(72*3))*Count
  }
    
 
  #declare Count = Count+1; 
#end

} // fin de Tour

#declare Eau = texture {
  pigment { rgbf <0.75, 0.95, 1, 1> }
  finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.05
    specular .9
    roughness 0.001}
  normal {agate agate_turb 1 scale 10} 
  }

//Le lombric
#declare Lombric = difference {

        sphere_sweep {
        cubic_spline                // alternative spline curves
        9,                            // number of specified sphere positions
        0, 0.1                // position, radius
        <0, -2, 0>, 0.1                 // ...
        < -0.5, -1, 0>, 0.3
        < -2.5, 0, 0>, 1
        <-2.5, 3, 0>, 0.5
        <-2, 4.5, 0>, 1
        <-1, 4.5, 0>, 1
        <01, 5, 0>, 1.4
        <2, 6, 0>, 1.5        
        
        texture {
    pigment {
      color rgb <0.8,0.8,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.0
      specular 0.6
      reflection {
        0.8
        metallic
      }
      conserve_energy
    }
   }
  }

box {<1, 3, -3> , <3, 7, 3> }
}

//fin du lombric

#declare R2 = seed(1);

// ----------------------------------------
#declare N = 30;
camera {   

  location <-90, 26+N,  45>
 look_at   <-90, 7+N, 115>
 up y*image_height/image_width
 right x
 
}

/*camera {   //altitude

  location <-90, 250, 115>
 look_at   <-90, 7, 115>
 up y*image_height/image_width
 right x
 
}*/


/*Camera gros plan tour   
camera {location <11, 3, 3> look_at <5, 3, 0>   }  */
   
background {Black}

light_source {
  <0, 200,  0>      
  color White*0.001
}

#declare Scene = union
{

object {Tour no_shadow}

object {Cerveau texture {pigment {color Pink}} rotate -90*x+90*y translate <0, 18, 0> no_shadow double_illuminate}





blob
{  threshold 0.3
   #declare Index = 1;
   #while(Index <= 36)
      sphere { <9+rand(R2)*2-1, rand(R2)*2-1, 0>, rand(R2)*2+1, 1 rotate y*10*Index} 
      #declare Index = Index + 1;
   #end
   
   texture {Eau}
translate y*1
}
 

 

// Les quatre blobs autour de la tour

#declare RadiusVal   = 1.0;
#declare StrengthVal = 2.0;
#declare Deca = 1.5;

#declare Count=0;
#while (Count<4)
blob {
  
  threshold 0.8
  sphere { < rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2)>, RadiusVal, StrengthVal }
  sphere { < rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2)>, RadiusVal, StrengthVal }
  sphere { <rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2)>, RadiusVal, StrengthVal }
  sphere { <rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2),rand(R2)*Deca-(Deca/2)>, RadiusVal, StrengthVal }
  
  
  scale 2
  
  translate 13*x+9*y
  rotate (90*Count+45)*y
  
  texture {Eau}

}  
#declare Count=Count+1;
#end 

//Fin des quatre blobs

// Le lombric   

object {Lombric scale 1.5 translate <-15, 3, -15>}

// Oeil

object {Oeil translate <15, 0, -15>}

// Lit

object {Lit scale 0.3 rotate y*-30 rotate x*-20 translate <-15, 10, 15>}

// Bibliothque

object {Bibli scale 1.6 rotate <25, 20, 0> translate <15, 10, 15>}

}
//fin de l'union Scene
    

 
#declare HF = height_field {
  tga
  "field4.tga"
 smooth  
 rotate y*(180+90)
 scale 160*(x+0.5*y+z)       
}

light_group {
	light_source {<0, 17.5, 0>  White fade_distance 10 fade_power 2 translate <-90, N, 110>}
	object {Scene scale 0.8 translate <-90, N, 110>}
}

light_group {

//Macro pour placer les lumires

#declare Terrain = HF;

#declare Pas=20;
#declare Debut=min_extent(Terrain);
#declare Fin=max_extent(Terrain);
#declare Hauteur_depart=max_extent(Terrain).y+1;
#declare Direction=-y;
#declare Norm=<0,0,0>; //on initialise le vecteur qui doit recueillir la normale renvoye par trace()
#declare Turb=<1,0,1>*0.2;//On remet de la turbulence(plus b) 
#declare Frequence=4;

#declare Pointeur_z=Debut.z; 
#while (Pointeur_z<Fin.z) 
        #declare Pointeur_x=Debut.x;  
        #while (Pointeur_x<Fin.x) 
                #declare Position=<Pointeur_x,Hauteur_depart,Pointeur_z>; 
                #declare Position=Position +vturbulence(2,.5,6,Position*Frequence)*Turb;
                #declare Intersect=trace(Terrain,Position,Direction,Norm);// L'appel de trace()  
                #if (vlength(Norm))// on teste s'il y a intersection (si le vecteur Norm n'est pas nul)  
                        //object {Mon_objet translate Intersect+5*y}
						
						light_source {
							<0, 0, 0>
							rgb 0.5*<rand(R2), rand(R2), rand(R2)>
							translate Intersect+5*y
							fade_power 2
							fade_distance 7
							shadowless
						}

                #end  
                #declare Pointeur_x=Pointeur_x+Pas;  
        #end // fin de la boucle x
        #declare Pointeur_z=Pointeur_z+Pas; 
#end 

object {HF pigment {color White}}

// Macro MakeSnow

#declare Particles = 1000;
#declare Size = 3;
#declare Thickness = 1;

MakeSnow(HF,Particles,Size,Thickness,MinHeight,MaxHeight,Direction)

} // fin du 2 light group

sky_sphere {pigment {color Black}}



